// in this example the coroutine reads row-by-row text from a file, converts into string and yields to the caller
#include <coroutine>
class ReturnType
{
public:
	struct promise_type
	{
		string coro_value = string("");
		auto get_return_object() { return ReturOType{ coroutine_handle<promise_type>::from_promise(*this) }; }
		auto initial_suspend() { return suspend_always(); }
		void unhandled_exception() { terminate(); }
		void return_void() { }
		auto final_suspend() noexcept { return suspend_always(); }
		auto yield_value(string val)
		{
			coro_value = val;
			return suspend_always();
		}
	};
	coroutine_handle<promise_type> handle;
	ReturnType(coroutine_handle<promise_type> h) : handle(h) {}
	~ReturnType() { handle.destroy(); } // method destroy() from class coroutine_handle<promise_type> destroys coroutine
	bool resume() const
	{
		if (!handle || handle.done())
		{ 
			return false;
		}
		handle.resume(); 
		return !handle.done();
	}
	string getValue() const
	{
		return handle.promise().coro_value;
	}
};

ReturnType coro_reader(fstream& f)
{
	cout << "started" << endl;
	char line[256];
	while (true)
	{
		f.getline(line, 256);
		if (f.eof())
		{
			cout << "No more data" << endl;
			break;
		}
		co_yield string(line);
	}
	cout << "ended" << endl;
}

void Test()
{
	fstream File;
	File.open("C:\\Temp\\sometext.txt", fstream::in);
	if (!File.good())
	{
		cout << "Failed to open file" << endl;
		return;
	}
	ReturnType task = coro_reader(File);
	while (true)
	{
		cout << "Press a key to continue, ESC to stop" << endl;
		if (_getch() == 27)
		{
			break;  // ESC - stop reading from file
		}
		if (!task.resume())  // When coro_reader has suspended its work, resume it after keystroke
		{
			break;  // coroutine has exited
		}
		else
		{
			cout << task.getValue() << endl;
		}
	}
	File.close();
}